/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.items.trinkets;

import com.glisco.things.Things;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.mixin.ItemUsageContextAccessor;
import com.glisco.things.text.AgglomerationTooltipData;
import com.glisco.things.text.TooltipComponentText;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoryItem;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationAttributes;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.network.ServerAccess;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_583;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class AgglomerationItem
extends AccessoryItem
implements AccessoryNest,
AccessoryRenderer {
    public AgglomerationItem() {
        super(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8907));
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        return this.getStackAndRun(stack, player, innerStack -> innerStack.method_31576(class_1799.field_8037, slot, clickType, player, cursorStackReference), () -> false);
    }

    public class_1269 method_7884(class_1838 context) {
        return this.getStackAndRun(context.method_8041(), context.method_8036(), innerStack -> innerStack.method_7981(new class_1838(context.method_8045(), context.method_8036(), context.method_20287(), innerStack, ((ItemUsageContextAccessor)context).things$getHitResult())), () -> class_1269.field_5814);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1657 player;
        return this.getStackAndRun(stack, user instanceof class_1657 ? (player = (class_1657)user) : null, innerStack -> innerStack.method_7910(world, user), () -> stack);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        return this.getStackAndRun(stack, player, innerStack -> innerStack.method_31575(slot, clickType, player), () -> false);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1657 player;
        return this.getStackAndRun(stack, attacker instanceof class_1657 ? (player = (class_1657)attacker) : null, innerStack -> {
            innerStack.method_7979(target, (class_1657)attacker);
            return true;
        }, () -> false);
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        class_1657 player;
        return this.getStackAndRun(stack, miner instanceof class_1657 ? (player = (class_1657)miner) : null, innerStack -> {
            innerStack.method_7952(world, state, pos, (class_1657)miner);
            return true;
        }, () -> false);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        return this.getStackAndRun(stack, user, innerStack -> innerStack.method_7920(user, entity, hand), () -> class_1269.field_5814);
    }

    public boolean method_7838(class_1799 stack) {
        return this.getStackAndRun(stack, null, class_1799::method_7967, () -> false);
    }

    public <T> T getStackAndRun(class_1799 stack, class_1657 player, Function<class_1799, T> methodPassthru, Supplier<T> error) {
        Object value = AccessoryNest.attemptFunction((class_1799)stack, (class_1309)player, map -> {
            int index = 0;
            int selectedTrinket = AgglomerationItem.getSelectedIndex(stack);
            if (selectedTrinket >= map.size()) {
                return error.get();
            }
            for (Map.Entry entry : map.entrySet()) {
                if (index == selectedTrinket) {
                    return methodPassthru.apply((class_1799)entry.getKey());
                }
                ++index;
            }
            return null;
        }, null);
        return (T)(value != null ? value : error.get());
    }

    public static void scrollSelectedStack(class_1799 stack) {
        stack.method_57368(SelectedStackComponent.COMPONENT_TYPE, (Object)SelectedStackComponent.DEFAULT, component -> new SelectedStackComponent(component.index() == 0 ? 1 : 0));
    }

    public static int getSelectedIndex(class_1799 stack) {
        return ((SelectedStackComponent)stack.method_57825(SelectedStackComponent.COMPONENT_TYPE, (Object)SelectedStackComponent.DEFAULT)).index();
    }

    public static class_1799 createStack(class_1799 ... items) {
        class_1799 stack = new class_1799((class_1935)ThingsItems.AGGLOMERATION, 1);
        stack.method_57379(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)new AccessoryNestContainerContents(Arrays.stream(items).map(class_1799::method_7972).toList()));
        stack.method_57379(SelectedStackComponent.COMPONENT_TYPE, (Object)new SelectedStackComponent(0));
        return stack;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData((class_1799)user.method_5998(hand));
        if (data != null) {
            for (class_1799 stack : data.accessories()) {
                if (!stack.method_7960()) continue;
                class_1799 cake = new class_1799((class_1935)class_1802.field_17534);
                cake.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)"item.things.consolation_cake"));
                user.method_31548().method_7398(cake);
                return class_1271.method_22427((Object)class_1799.field_8037);
            }
        }
        return super.method_7836(world, user, hand);
    }

    public boolean canEquip(class_1799 stack, SlotReference slot) {
        TriState state;
        Boolean isInnerStacksValid = (Boolean)AccessoryNest.attemptFunction((class_1799)stack, (SlotReference)slot, map -> {
            for (SlotEntryReference entryRef : map.keySet()) {
                if (AccessoriesAPI.canInsertIntoSlot((class_1799)entryRef.stack(), (SlotReference)entryRef.reference())) continue;
                return false;
            }
            return true;
        }, (Object)false);
        SlotType slotType = SlotTypeLoader.getSlotType((class_1309)slot.entity(), (String)slot.slotName());
        Set validators = slotType.validators();
        if (!isInnerStacksValid.booleanValue() && validators.contains(Accessories.of((String)"component")) && (state = AccessoriesAPI.getPredicate((class_2960)Accessories.of((String)"component")).isValid(slot.entity().method_37908(), slotType, slot.slot(), stack)) == TriState.TRUE) {
            return true;
        }
        return isInnerStacksValid;
    }

    public boolean canUnequip(class_1799 stack, SlotReference reference) {
        if (AccessoryNestUtils.getData((class_1799)stack) == null) {
            return true;
        }
        return super.canUnequip(stack, reference);
    }

    public void getExtraTooltip(class_1799 stack, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData((class_1799)stack);
        if (data == null) {
            return;
        }
        List subStacks = data.accessories();
        ArrayList<TooltipComponentText> innerTooltipData = new ArrayList<TooltipComponentText>();
        for (int i = 0; i < subStacks.size(); ++i) {
            class_1799 subStack = (class_1799)subStacks.get(i);
            List subTooltip = ((class_1799)subStacks.get(i)).method_7950(tooltipContext, null, tooltipType);
            for (int j = 0; j < subTooltip.size(); ++j) {
                if (j == 0) {
                    TooltipComponentText text = new TooltipComponentText(new AgglomerationTooltipData((class_2561)class_2561.method_43470((String)(AgglomerationItem.getSelectedIndex(stack) == i ? "> " : "\u2022 ")), subStack, (class_2561)subTooltip.get(j)));
                    innerTooltipData.add(text);
                    continue;
                }
                innerTooltipData.add((TooltipComponentText)class_2561.method_43470((String)"  ").method_10852((class_2561)subTooltip.get(j)));
            }
        }
        for (class_1799 subStack : subStacks) {
            if (!subStack.method_7960()) continue;
            innerTooltipData.add((TooltipComponentText)class_2561.method_43473());
            innerTooltipData.add((TooltipComponentText)class_2561.method_43471((String)"item.things.consolation_cake.hint"));
        }
        tooltips.addAll(0, innerTooltipData);
    }

    public void onStackChanges(class_1799 holderStack, AccessoryNestContainerContents data, @Nullable class_1309 livingEntity) {
        for (class_1799 accessory : data.accessories()) {
            if (!accessory.method_31574(class_1802.field_8162) || !(livingEntity instanceof class_3222)) continue;
            class_3222 player = (class_3222)livingEntity;
            Things.AN_AMAZINGLY_EXPENSIVE_MISTAKE_CRITERION.trigger(player);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public <M extends class_1309> void render(class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!Things.CONFIG.renderAgglomerationTrinket()) {
            return;
        }
        AccessoryNest.attemptConsumer((class_1799)stack, (SlotReference)reference, map -> map.forEach((slotEntryReference, accessory) -> {
            class_1799 subStack = slotEntryReference.stack();
            AccessoryRenderer renderer = AccessoriesRendererRegistry.getRender((class_1799)subStack);
            if (renderer != null) {
                matrices.method_22903();
                renderer.render(subStack, reference, matrices, model, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                matrices.method_22909();
            }
        }));
    }

    public record SelectedStackComponent(int index) {
        public static final SelectedStackComponent DEFAULT = new SelectedStackComponent(0);
        public static final Endec<SelectedStackComponent> ENDEC = StructEndecBuilder.of((StructField)Endec.ifAttr((SerializationAttribute)SerializationAttributes.HUMAN_READABLE, (Endec)Endec.INT).orElse(Endec.VAR_INT).fieldOf("index", SelectedStackComponent::index), SelectedStackComponent::new);
        public static final class_9331<SelectedStackComponent> COMPONENT_TYPE = class_9331.method_57873().method_57881(CodecUtils.toCodec(ENDEC)).method_57882(CodecUtils.toPacketCodec(ENDEC)).method_59871().method_57880();
    }

    public record ScrollStackFromSlotTrinket(boolean fromPlayerInv, int slotId) {
        public static void scrollItemStack(ScrollStackFromSlotTrinket message, ServerAccess access) {
            class_1799 stack;
            class_1799 class_17992 = stack = message.fromPlayerInv ? access.player().method_31548().method_5438(message.slotId) : access.player().field_7512.method_7611(message.slotId).method_7677();
            if (stack == null) {
                return;
            }
            AgglomerationItem.scrollSelectedStack(stack);
        }
    }

    public record ScrollHandStackTrinket(boolean mainHandStack) {
        public static void scrollItemStack(ScrollHandStackTrinket message, ServerAccess access) {
            class_1799 stack = message.mainHandStack ? access.player().method_6047() : access.player().method_6079();
            AgglomerationItem.scrollSelectedStack(stack);
            AccessoryNestContainerContents data = AccessoryNestUtils.getData((class_1799)stack);
            access.player().method_43502((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)class_2561.method_43471((String)((class_1799)data.accessories().get(AgglomerationItem.getSelectedIndex(stack))).method_7922())), true);
        }
    }
}

